/*
** openMosix "struct mosix_info"s used by mosmon
**
** Copyright (C) 2004  Moreno 'baro' Baricevic
**                                      <baro AT democritos DOT it>
**
** This  file may be used subject to the terms and conditions of the
** GNU Library General Public License as published by the Free Soft-
** ware Foundation; either version 2 of the License, or (at your op-
** tion) any later version.
**
** This file is distributed in the hope that it will be useful,  but
** WITHOUT  ANY  WARRANTY; without even the implied warranty of MER-
** CHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Li-
** brary General Public License for more details.
*/

/**************************************************
 * Author: Moreno 'baro' Baricevic                *
 * Date:   15 Mar 2004                            *
 * Title:  mosix_info.h                           *
 *================================================*
 * Prev Modified: 15 Mar 2004                     *
 * Prev Modified: 19 Mar 2004                     *
 * Prev Modified: 20 Mar 2004                     *
 * Prev Modified: 21 Mar 2004                     *
 * Prev Modified: 25 Mar 2004                     *
 * Prev Modified: 06 Apr 2004                     *
 * Last Modified: 19 Jun 2004                     *
 **************************************************/

#ifndef _MOSIX_INFO_H_
#define _MOSIX_INFO_H_

#include "version.h"

#include <stdint.h>	// u?int[0-9]+_t
#include <sys/types.h>	// off_t
#include <unistd.h>	// lseek, read
#include <stdlib.h>	// free

#define PROC_HPC_INFOS	"/proc/hpc/info/infos"

#define MAX_RECSZ	256	// large enough to contain any struct


enum {
     _2416 = 0
   , _2419 = 1
   , _2421
   , _2422
   , _2423
   , _2424
   , _26xx
   , _UNKNOWN = -1
   , _DUMMY = _UNKNOWN
};



/******************************************************************************
** 2.4.16
** range: 2.4.16-[67], 2.4.17-1
** oMver: 1.5.4, 1.5.8
** comment: only if defined CONFIG_MOSIX_RESEARCH, else falls into 2419
*/
struct mosix_info_2416 {
        unsigned long load;
        unsigned short speed;
        unsigned short ncpus;
        unsigned short util;
        unsigned short status;
        unsigned long mem;
        unsigned long rmem;
        unsigned long tmem;
        unsigned int rio;   /* read io  */	//ifdef CONFIG_MOSIX_RESEARCH
        unsigned int wio;   /* write io */	//ifdef CONFIG_MOSIX_RESEARCH
};
#define RECSZ_2416	sizeof( struct mosix_info_2416 )



/******************************************************************************
** 2.4.19
** range: 2.4.17-[23], 2.4.18-[1234], 2.4.19-[123467], 2.4.20-[12] (, 2.4.20-3_NO_LL)
** oMver: 1.5.8, 1.5.9, 1.6.0, 1.6.5, 1.6.7, 1.6.8 (, 1.6.9)
** comment: 2.4.20-3 only if CONFIG_MOSIX_LOADLIMIT disabled
*/
struct mosix_info_2419 {
        unsigned long load;
        unsigned short speed;
        unsigned short ncpus;
        unsigned short util;
        unsigned short status;
        unsigned long mem;
        unsigned long rmem;
        unsigned long tmem;
};
#define RECSZ_2419	sizeof( struct mosix_info_2419 )



/******************************************************************************
** 2.4.21
** range: (2.4.20-3_LL,) 2.4.21-1, 2.4.22-1
** oMver: (1.6.9,) 1.7.0
** comment: 2.4.20-3 only if CONFIG_MOSIX_LOADLIMIT enabled
*/
struct mosix_info_2421 {
        unsigned long load;
        unsigned long load_limit; /* MOSIX_LOADLIMIT */
        unsigned long llimitmode;
        unsigned long loadremote;
        unsigned long loadlocal;
        unsigned long cpu_limit; /* MOSIX_LOADLIMIT */
        unsigned long cpulimitmode;
        unsigned long cpuremote;
        unsigned long cpulocal;
        unsigned short speed;
        unsigned short ncpus;
        unsigned short util;
        unsigned short status;
        unsigned long mem;
        unsigned long rmem;
        unsigned long tmem;
};
#define RECSZ_2421	sizeof( struct mosix_info_2421 )



/******************************************************************************
** 2.4.22-2 (2.4.22-3 only change from unsigned to signed 64)
** range: 2.4.22-2	(,2.4.22-3)
** oMver: 1.8.0		(,1.9.0)
** comment:
*/
struct mosix_info_2422 {
        unsigned long load;
        unsigned long load_limit; /* MOSIX_LOADLIMIT */
        unsigned long llimitmode;
        unsigned long loadremote;
        unsigned long loadlocal;
        unsigned long cpu_limit; /* MOSIX_LOADLIMIT */
        unsigned long cpulimitmode;
        unsigned long cpuremote;
        unsigned long cpulocal;
        unsigned short speed;
        unsigned short ncpus;
        unsigned short util;
        unsigned short status;
        uint64_t mem;
        uint64_t rmem;
        uint64_t tmem;
};
#define RECSZ_2422	sizeof( struct mosix_info_2422 )



#if 0	//{
#warning "mosix_info_2422d should fall into mosix_info_2422"
/******************************************************************************
** 2.4.22-3, 2.4.22-om-20031215
** range: 2.4.22-3	(, 2.4.22-om-20031215, 2.4.23-om-20031215)
** oMver: 1.9.0		(, 1.8.0)
** comment: doesn't matter if *mem change from uint64_t to int64_t,
**          field and struct size don't change
*/
struct mosix_info_2422d {
        unsigned long load;
        unsigned long load_limit; /* MOSIX_LOADLIMIT */
        unsigned long llimitmode;
        unsigned long loadremote;
        unsigned long loadlocal;
        unsigned long cpu_limit; /* MOSIX_LOADLIMIT */
        unsigned long cpulimitmode;
        unsigned long cpuremote;
        unsigned long cpulocal;
        unsigned short speed;
        unsigned short ncpus;
        unsigned short util;
        unsigned short status;
        int64_t mem;
        int64_t rmem;
        int64_t tmem;
};
#define RECSZ_2422d	sizeof( struct mosix_info_2422d )
#endif	//}



/******************************************************************************
** 2.4.23 pre
** range: 2.4.23-om-20040128, 2.4.24-om-20040312, 2.4.25-om-20040312
** oMver: 1.8.0
** comment: new standard? no
*/
struct mosix_info_2423 {
        unsigned long load;
        unsigned short speed;
        unsigned short ncpus;
        unsigned short util;
        unsigned short status;
        int64_t mem;
        int64_t rmem;
        int64_t tmem;
};
#define RECSZ_2423	sizeof( struct mosix_info_2423 )



/******************************************************************************
** 2.4.24
** range: 2.4.24-om1
** oMver: 1.9.4
** comment: new standard?
*/
struct mosix_info_2424 {
        unsigned long load;
        unsigned short speed;
        unsigned short ncpus;
        unsigned short util;
        unsigned short status;
        int64_t mem;
        int64_t rmem;
        int64_t tmem;
        unsigned long load_limit; /* MOSIX_LOADLIMIT */
        unsigned long llimitmode;
        unsigned long loadremote;
        unsigned long loadlocal;
        unsigned long cpu_limit; /* MOSIX_LOADLIMIT */
        unsigned long cpulimitmode;
        unsigned long cpuremote;
        unsigned long cpulocal;
};
#define RECSZ_2424	sizeof( struct mosix_info_2424 )



#if 0	//{
#error "kernel 2.6.x is not yet supported"
/******************************************************************************
** 2.6.x
** range:
** oMver:
** comment: coming soon
*/
struct mosix_info_26xx {
	void * dummy;
};
#define RECSZ_26xx	sizeof( struct mosix_info_26xx )
#endif	//}



/******************************************************************************
** dummy: avoid the worst
*/
struct mosix_info_DUMMY {
	void * dummy;
};
#define RECSZ_DUMMY	sizeof( struct mosix_info_DUMMY )



/******************************************************************************
** assume this as interoperability standard struct (for future use?)
*/
typedef struct mosix_info_2423 mosix_info_s;
#define RECSZ_STD	sizeof( mosix_info_s )



/******************************************************************************
** exported routines and variables
*/

extern int recsz;		// current mosix_info_XXXX size
extern char mstruct[16];	// "mosix_info_XXXX" as string

/*
** declare some routines, wrappers for read()
*/
#define DECLARE_READSTRUCT( type )	\
	extern int readstruct_ ## type ( int , mosix_info_s * , size_t );

DECLARE_READSTRUCT( 2416 )
DECLARE_READSTRUCT( 2419 )
DECLARE_READSTRUCT( 2421 )
DECLARE_READSTRUCT( 2422 )
DECLARE_READSTRUCT( 2423 )
DECLARE_READSTRUCT( 2424 )
DECLARE_READSTRUCT( DUMMY )

#undef DECLARE_READSTRUCT

/*
** readstruct_* handler
*/
extern int ( * readstruct )( int , mosix_info_s * , size_t );

/*
** assign recsz, readstruct and mstruct
*/
extern int guess_by_recsz( int fd );
extern int force_version( int ver );
#ifdef DEBUG
extern void summary( void );
extern void print_strinfo ( mosix_info_s * mis );
#endif


#endif /* _MOSIX_INFO_H_ */



/***********************  E N D   O F   F I L E  ************************/

