/*
** Additional routines used by mosmon
**
** Copyright (C) 2004  Moreno 'baro' Baricevic
**                                      <baro AT democritos DOT it>
**
** This  file may be used subject to the terms and conditions of the
** GNU Library General Public License as published by the Free Soft-
** ware Foundation; either version 2 of the License, or (at your op-
** tion) any later version.
**
** This file is distributed in the hope that it will be useful,  but
** WITHOUT  ANY  WARRANTY; without even the implied warranty of MER-
** CHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Li-
** brary General Public License for more details.
*/

/**************************************************
 * Author: Moreno 'baro' Baricevic                *
 * Date:   13 Mar 2004                            *
 * Title:  utils.c                                *
 *================================================*
 * Prev Modified: 13 Mar 2004                     *
 * Prev Modified: 17 Mar 2004                     *
 * Prev Modified: 19 Mar 2004                     *
 * Prev Modified: 20 Mar 2004                     *
 * Prev Modified: 21 Mar 2004                     *
 * Prev Modified: 25 Mar 2004                     *
 * Last Modified: 06 Apr 2004                     *
 **************************************************/


#include "utils.h"


#include <stdarg.h>
/******************************************************************
 *_____________________________  DIE _____________________________*
 ******************************************************************/
/*
** mmh, something's gone wrong
*/
void die ( const char * errmsg , ... )
{

   if ( errno )
     fprintf( stderr , "*** errno: [%d] %m\n" , errno );

   if ( errmsg && *errmsg )
   {
      va_list args;
      va_start( args , errmsg );
      vfprintf( stderr , errmsg , args );
      va_end( args );
      putc( '\n' , stderr );
   }
   exit( 1 );

} /* die */



/***********************************************************************
 *_____________________________  XCMALLOC _____________________________*
 ***********************************************************************/
/* (om)procps/proc/ominfo.c */
/*
** allocates zeroed memory buffer.
** Dies only on system failure (ENOMEM), not bugs(?) like size<=0.
*/
void * xcmalloc ( const size_t size )
{

   errno = 0;

   if ( size > 0 )
   {
      register void * ptr = malloc( size );
      if ( ptr == NULL )
      {
         fprintf( stderr , "%s: allocation error, size = %d\n"
                         , __FUNCTION__ , size );
         exit( 1 );
      }
      DBGprint( "%d bytes allocated on %p" , size , ptr );
      return memset( ptr , 0 , size );
   }

   errno = EINVAL;

   return NULL;

} /* xcmalloc */



/*********************************************************************
 *_____________________________  STRTOI _____________________________*
 *********************************************************************/
/* (om)procps/proc/ominfo.c */
/*
** converts a string to an integer (the whole string must be a number).
** Wrapper to strtol (int64_t on 64bits, int32_t on 32bits)
** Needs <limits.h> and <bits/wordsize.h>.
*/
int strtoi ( const char * string )
{

   errno = 0;

   if ( string && *string )
   {

      char * junk = NULL;
      long lval = strtol( string , &junk , 10 );

      if ( string != junk && *junk == '\0' )
      {
#if __WORDSIZE == 64    // long == int64_t
         if ( lval > INT_MAX )
         {
            errno = ERANGE;
            lval = INT_MAX;
         }
         if ( lval < INT_MIN )
         {
            errno = ERANGE;
            lval = INT_MIN;
         }
#endif
         return (int)lval;
      }
   }

   errno = EINVAL;

   return 0;

} /* strtoi */



#ifdef DEBUG

/************************************************************************
 *_____________________________  STDREOPEN _____________________________*
 ************************************************************************/
/*
** stderr to console (or devnull on failure) -- (debug)
** (I use xconsole...)
*/
void stdreopen( void )
{

   int fade;

   (void)close( STDERR_FILENO );

   fade = open( "/dev/console" , O_APPEND | O_WRONLY );
   if ( fade == -1 )	// mmh, check your console permissions/owner
   {
#ifdef IGNORE_CONSOLE
      fade = open( "/dev/null" , O_APPEND | O_WRONLY );
      if ( fade == -1 )	// sticazzi!
        abort();
#else /* IGNORE_CONSOLE */
      dup2( STDOUT_FILENO , STDERR_FILENO );
      die( "mmh, check your console permissions" );
#endif /* IGNORE_CONSOLE */
   }

   (void)dup2( fade , STDERR_FILENO ) ,

   (void)setvbuf( stderr , (char *)NULL, _IONBF, 0 );

} /* stdreopen */

#endif /* DEBUG */




/***********************  E N D   O F   F I L E  ************************/

