/*
** Header for additional routines used by mosmon
**
** Copyright (C) 2004  Moreno 'baro' Baricevic
**                                      <baro AT democritos DOT it>
**
** This  file may be used subject to the terms and conditions of the
** GNU Library General Public License as published by the Free Soft-
** ware Foundation; either version 2 of the License, or (at your op-
** tion) any later version.
**
** This file is distributed in the hope that it will be useful,  but
** WITHOUT  ANY  WARRANTY; without even the implied warranty of MER-
** CHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Li-
** brary General Public License for more details.
*/

/**************************************************
 * Author: Moreno 'baro' Baricevic                *
 * Date:   13 Mar 2004                            *
 * Title:  utils.h                                *
 *================================================*
 * Prev Modified: 13 Mar 2004                     *
 * Prev Modified: 17 Mar 2004                     *
 * Prev Modified: 21 Mar 2004                     *
 * Prev Modified: 25 Mar 2004                     *
 * Last Modified: 06 Apr 2004                     *
 **************************************************/

#ifndef _UTILS_H_
#define _UTILS_H_


#include <stdio.h>
#include <errno.h>
#include <unistd.h>	// lseek, read, dup2
#include <stdlib.h>	// exit, malloc, strtol
#include <string.h>	// memset
#include <fcntl.h>	// open, O_RDONLY
#include <sys/stat.h>	// S_IREAD, S_IWRITE


/**************************************************************
** oM flags (hpc/hpcctl.h)
*/
#include <limits.h>	// USHRT_MAX, INT_MIN, INT_MAX, <bits/wordsize.h>
#define MOSIX_MAX       USHRT_MAX	//65535

#define DS_MOSIX_DEF    0x001
#define DS_MOSIX_UP     0x002
#define DS_STAY         0x004
#define DS_LSTAY        0x008
#define DS_BLOCK        0x010
#define DS_QUIET        0x020
#define DS_NOMFS        0x040


/**************************************************************
** oM struct mosix_info (hpc/hpcctl.h)
*/
//#include <linux/config.h>
//#include <hpc/hpcctl.h>


/**************************************************************
** common routines (utils.c)
*/
extern void die( const char * errmsg , ... );
extern int strtoi ( const char * string );
extern void * xcmalloc ( const size_t size );
#ifdef DEBUG
extern void stdreopen( void );
#endif


/**************************************************************
** debug stuff
*/

#ifdef DEBUG
# define DBGprint( fmt , args... )				\
	{							\
	   fprintf( stderr					\
	            , "[%-18s:%4d][%-24.24s] " fmt "\n"		\
	            , __FILE__ , __LINE__ , __FUNCTION__	\
	            , ## args					\
	          );						\
	}
#else
# define DBGprint( _... )	{}
#endif


#endif /* _UTILS_H_ */




/***********************  E N D   O F   F I L E  ************************/

