/* Suite version information for procps utilities
 * Copyright (c) 1995 Martin Schulze <joey@infodrom.north.de>
 * Ammended by cblake to only export the function symbol.
 *
 * Modified by Albert Cahalan, ????-2003
 *
 * Modified by Moreno 'baro' Baricevic <baro@democritos.it>, Feb 2004
 *
 * Redistributable under the terms of the
 * GNU Library General Public License; see COPYING
 */

#include <stdio.h>
#include <stdlib.h>

#include "version.h"

/******************************************************************************
** Linux kernel version information for procps utilities
** Copyright (c) 1996 Charles Blake <cblake@bbn.com>
** Modified by Moreno 'baro' Baricevic <baro@democritos.it>, Feb 2004
*/

#include <sys/utsname.h>
#include <string.h>

int linux_version_code;
char linux_extraversion[32];	// DON'T RELY ON THIS
#define EXTV linux_extraversion

static void init_Linux_version(void) __attribute__((constructor));
static void init_Linux_version(void)
{
   static struct utsname uts;
   int x = 0, y = 0, z = 0;	/* cleared in case sscanf() < 3 */

   memset( EXTV , 0 , sizeof( EXTV ) );

   if ( uname( &uts ) == -1 )	/* failure implies impending death */
     exit( 1 );


//   sprintf( uts.release , "2.4.20-3" );


   if ( sscanf( uts.release , "%d.%d.%d-%32s" , &x , &y , &z , EXTV ) < 3 )
     fprintf( stderr ,		/* *very* unlikely to happen by accident */
              "Non-standard uts for running kernel:\n"
              "release %s=%d.%d.%d gives version code %d, extraversion %s\n"
              , uts.release, x, y, z, LINUX_VERSION( x , y , z )
              , ( EXTV && *EXTV ) ? EXTV : "unknown"
            );

   linux_version_code = LINUX_VERSION( x , y , z );

/* look at kernel version (debug only) */
   VRBprint( "kernel release %s = %d.%d.%d, version code %d, extraversion %s\n"
             , uts.release , x , y , z , LINUX_VERSION( x , y , z )
             , *EXTV ? EXTV : "unknown"
           );

   kernel_release.release = uts.release;
   kernel_release.version = linux_version_code;
   kernel_release.major = x;
   kernel_release.minor = y;
   kernel_release.patch = z;
   kernel_release.extra = *EXTV ? EXTV : NULL ;

} /* init_Linux_version */



/******************************************************************************
** openMosix version
** Moreno 'baro' Baricevic <baro@democritos.it>, Feb 2004
*/

#include <fcntl.h>
#include <unistd.h>

int mosix_version_code = -1;

static void init_openMosix_version(void) __attribute__((constructor));
static void init_openMosix_version(void)
{
   static char buf[32];	// should contain "openMosix Version a.b.c"
			// will be reused to store oMver

   int x = 0, y = 0, z = 0;	/* cleared in case sscanf() < 3 */

   int fd = open( PROC_HPC_VERSION , O_RDONLY );

   VRBprint( "openMosix release" );

   *buf=0;

   if ( fd != -1 )
   {
      int nr = read( fd , buf , sizeof( buf )-1 );
      buf[sizeof( buf )-1] = '\0';
      if ( nr != -1 )
      {
         /*
         ** - old version string: "Mosix Version x.y.z"
         ** - new version string: "openMosix Version x.y.z"
         */
         int ns = sscanf( buf , "%*[^s]six Version %d.%d.%d" , &x , &y , &z );
         if ( ns == 3 )
         {
            VRBprint( " %d.%d.%d," , x , y , z );
            mosix_version_code = MOSIX_VERSION( x , y , z );
            snprintf( buf , 32 , "%d.%d.%d" , x , y , z );
         }
         else
         {
            VRBprint( " unknown (%d fields scanned)," , ns );
            snprintf( buf , 32 , "unknown" );
         }
      }
      close( fd );
   }
   else
     VRBprint( ": info unavailable," );

   VRBprint( " version code %d\n" , mosix_version_code );

   openmosix_release.release = *buf ? buf : "unknown";
   openmosix_release.version = mosix_version_code;
   openmosix_release.major = x;
   openmosix_release.minor = y;
   openmosix_release.patch = z;
   openmosix_release.extra = NULL;

} /* init_openMosix_version */




#ifdef TEST_VERSION

int main (void)
{
   printf( "kernel VERSION: %s, %d.%d.%d%s%s, %d\n"
           , kernel_release.release
           , kernel_release.major
           , kernel_release.minor
           , kernel_release.patch
           , kernel_release.extra ? "-" : ""
           , kernel_release.extra ? kernel_release.extra : ""
           , kernel_release.version
         );
   printf( "openMosix VERSION: %s, %d.%d.%d, %d\n"
           , openmosix_release.release
           , openmosix_release.major
           , openmosix_release.minor
           , openmosix_release.patch
           , openmosix_release.version
         );
   printf( "kernel release %s (%d); openMosix release %s (%d)\n"
           , kernel_release.release    , kernel_release.version
           , openmosix_release.release , openmosix_release.version
         );
   return 0;
} /* main */

#endif /* TEST_VERSION */



/***********************  E N D   O F   F I L E  ************************/

