/*
 * Last modified by Moreno 'baro' Baricevic <baro@democritos.it>, Apr 2004
 *
 * Redistributable under the terms of the
 * GNU Library General Public License; see COPYING
 */

#ifndef _VERSION_H_
#define _VERSION_H_

extern int linux_version_code;
extern char linux_extraversion[32];

/* Convenience macros for composing/decomposing version codes */
#define LINUX_VERSION(x,y,z)   (0x10000*(x) + 0x100*(y) + z)
#define LINUX_VERSION_MAJOR(x) (((x)>>16) & 0xFF)
#define LINUX_VERSION_MINOR(x) (((x)>> 8) & 0xFF)
#define LINUX_VERSION_PATCH(x) ( (x)      & 0xFF)


#define PROC_HPC_VERSION	"/proc/hpc/admin/version"

extern int mosix_version_code;

//#define MOSIX_VERSION_PARTS(x)	(x)/10000, ((x)%10000)/100, (x)%100
#define MOSIX_VERSION(x,y,z)		( ((x)*10000) + ((y)*100) + (z) )


typedef struct
{
				// kernelver				| oMver
   const char * release;	// 2.4.23-om-20031215 (uts.release)	| 1.8.0
   int version;			// 132119				| 10800
   int major;			// 2					| 1
   int minor;			// 4					| 8
   int patch;			// 23					| 0
   const char * extra;		// om-20031215				| NULL
} release_s;

release_s kernel_release;
release_s openmosix_release;

#ifdef DEBUG
#define VRBprint(fmt,args...)   { fprintf( stderr , fmt , ## args ); }
#else
#define VRBprint(_...)          {}
#endif

#endif	/* _VERSION_H_ */



/***********************  E N D   O F   F I L E  ************************/

